# Page Titles and URLs

This guide covers titles and urls in Refinery Pages. After reading it, you should be familiar with:

* Customizing titles shown on pages and menus
* Customizing titles shown in the browser window (the html title tag) for SEO purposes
* Customizing the slugs that are automatically generated by Refinery
* Excluding a route from Refinery's list of reserved words

## Title

A page's title is set by entering text in the "Title" field on the edit page screen. This title is displayed at the top of pages in the default theme and is available via the page_title variable in your custom views. By default, this title is also used in the site's menu and for part of the browser title (html title tag). Additionally, the title is used as the basis for creating a friendly ID or slug for the page. (ex. "Welcome to our site" would be assigned a slug of "welcome-to-our-site").

## Menu Title

In some situations, you may want to have a different title appear in the site menu than on the page itself. For example, you may want to have the menu simply display "Welcome" while the page says "Welcome to our site." Enter the text you want to appear in the menu in the Menu Title field under Advanced Options. Also, setting this option will create a new slug for your page (ex. If Menu Title is set to "Welcome" your slug will be "welcome").

## Browser Title

For SEO purposes, it is sometimes useful to have specific keywords within the html title tag. A custom browser title can be set in the Browser Title field under Advanced Options.

## Custom Slug

Sometimes you might need to change a page's slug from the default that Refinery generates for you. This is useful if you have pages with really long titles, if you need to support a legacy URL schema, if you are writing in a language that doesn't work well with Refinery's standard slug generation, or if you want to have consistent slugs across multiple locales.

To use custom slugs, open `config/initializers/refinery/pages.rb`, uncomment `config.use_custom_slugs = false` and set it to true. This will enable a "Custom slug" field in the Advanced Options section of the page editing screen. If text is entered in this field, it will be used as the basis for your slug instead of the Title or Menu Title.

## Reserved Words

By default, Refinery will scan your routes.rb file and add your routes as reserved words. This prevents Refinery Pages from interfering with your app. If you want to have a Refinery Page that has the same slug as a Rails route, you can add `:allow_slug => true` : `match '/cart', :to => 'cart#index', :allow_slug => true`

This will allow a page with slug 'cart', whereas the default behaviour would result in a page with slug 'cart-page'
